@echo off

:: 使用 PowerShell 取得 CPU 名稱並儲存到變數 K
for /f "delims=" %%i in ('powershell -command "Get-CimInstance -ClassName Win32_Processor | Select-Object -ExpandProperty Name"') do set "K=%%i"

:: 去除所有空格
set "K=%K: =%"

echo Process:%K%

if exist AFUWINx64* (
    del AFUWINx64*
    echo delete AFUWINx64*
)

if exist amigendrv64.sys* (
    del amigendrv64.sys*
    echo delete amigendrv64.sys*
) 

if exist B*.* (
    del B*.*
    echo B*.*
) 

for /l %%i in (5,-1,1) do (
    cls
    echo count down %%i second...
    ping -n 2 127.0.0.1 >nul
)

echo Copy files...
copy AFUWIN64\* .
copy BIOS\* .

:: 初始化變數
set "AFile="
set "BFile="
set "AFileCount=0"
set "BFileCount=0"

:: 搜尋 A 版檔案
for %%f in (*A) do (
    set /a AFileCount+=1
    set "AFile=%%f"
)

:: 搜尋 B 版檔案
for %%f in (*B) do (
    set /a BFileCount+=1
    set "BFile=%%f"
)

:: 檢查檔案數量
if %AFileCount% neq 1 (
    echo ERROR:Incorrect number of A version files.
    pause
    exit /b
)

if %BFileCount% neq 1 (
    echo ERROR:Incorrect number of B version files.
    pause
    exit /b
)

echo A ver:%AFile%
echo B ver:%BFile%


:: 檢查 CPU 型號並執行相應的批次檔
if not "%K:i7=%" == "%K%" (
    echo i7
    AFUWINx64.exe %BFile% /p /b /n /r /k
) else if not "%K:G6900=%" == "%K%" (
    echo G6900
    AFUWINx64.exe %AFile% /p /b /n /r /k
) else if not "%K:i3=%" == "%K%" (
    echo i3
    AFUWINx64.exe %AFile% /p /b /n /r /k
) else if not "%K:i5=%" == "%K%" (
    echo i5
    AFUWINx64.exe %BFile% /p /b /n /r /k
) else (
    echo no match.
)

echo Remove files...
if exist AFUWINx64* (
    del AFUWINx64*
    echo delete AFUWINx64*
)

if exist amigendrv64.sys* (
    del amigendrv64.sys*
    echo delete amigendrv64.sys*
) 

if exist B*.* (
    del B*.*
    echo B*.*
) 

pause