#!/bin/bash

if [[ $(/usr/bin/id -u) -ne 0 ]]; then
    echo -ne '\007'
    echo
    echo "The setup.sh must be run with sudo or as root."
    echo 
    exit
fi

Var=`ls /sys/class/gpio/ | grep 'gpiochip'`
Base=$(echo $Var | tr -d -c 0-9)

Sense=$(($Base+22))
Control=$(($Base+19))

# Show existing sense value:
echo Sensor gpio$Sense value before opening drawer:
cat /sys/class/gpio/gpio$Sense/value
echo

# Open the drawer
echo low > /sys/class/gpio/gpio$Control/direction
sleep 0.2
echo Sensor gpio$Sense value after open:
cat /sys/class/gpio/gpio$Sense/value
echo

# Put drawer in close mode
echo high > /sys/class/gpio/gpio$Control/direction
sleep 0.2
echo Sensor gpio$Sense value after write drawer as closed: 
cat /sys/class/gpio/gpio$Sense/value
echo
