#!/bin/bash

CONFIG_FILE="/etc/gdm3/custom.conf"

if [ -f "$CONFIG_FILE" ]; then

    if grep -q "^#WaylandEnable=false" "$CONFIG_FILE"; then
        sudo sed -i 's/^#WaylandEnable=false/WaylandEnable=false/' "$CONFIG_FILE"
        echo "Wayland has been disabled."
    elif grep -q "^WaylandEnable=false" "$CONFIG_FILE"; then
        echo "Wayland is already disabled."
    else
        echo "WaylandEnable=false" | sudo tee -a "$CONFIG_FILE" > /dev/null
        echo "Wayland has been disabled."
    fi
else
    echo "Error: GDM3 configuration file not found!"
fi

sudo systemctl restart gdm3

echo "GDM3 has been restarted."
