#!/bin/bash

#Get the touchscreen device name
TOUCHSCREEN_DEVICE="Elo Touch E3 15.6 AIO pCAP USB HID"

# Listen for orientation changes and rotate screen accordingly
monitor-sensor | while read -r line; do
  if [[ $line == *"Accelerometer orientation changed: normal"* ]]; then
    xrandr --output eDP-1 --rotate normal
    xinput set-prop "$TOUCHSCREEN_DEVICE" 'Coordinate Transformation Matrix' 1 0 0 0 1 0 0 0 1
  elif [[ $line == *"Accelerometer orientation changed: right-up"* ]]; then
    xrandr --output eDP-1 --rotate right
    xinput set-prop "$TOUCHSCREEN_DEVICE" 'Coordinate Transformation Matrix' 0 1 0 -1 0 1 0 0 1
  elif [[ $line == *"Accelerometer orientation changed: bottom-up"* ]]; then
    xrandr --output eDP-1 --rotate inverted
    xinput set-prop "$TOUCHSCREEN_DEVICE" 'Coordinate Transformation Matrix' -1 0 1 0 -1 1 0 0 1
  elif [[ $line == *"Accelerometer orientation changed: left-up"* ]]; then
    xrandr --output eDP-1 --rotate left
    xinput set-prop "$TOUCHSCREEN_DEVICE" 'Coordinate Transformation Matrix' 0 -1 1 1 0 0 0 0 1
  fi
  sleep 1
done
