/*
	CygUSB721XDemo - Copyright (C) 2007 Cygnetron Inc.


	CygUSB721XDemo is free software; you can redistribute it and/or modify.
	
	CygUSB721XDemo is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  


*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using System.Threading;
using SSIdll;
namespace exampleWinForm
{
    delegate void uu(string var, string var2);
    delegate void uuS(byte[] var);
   
      
/// <summary>
/// 
/// </summary>
    public partial class exDSRNET : Form
    {
        byte[] DSROffByteStream =  { 0x07, 0xC6, 0x04, 0x00, 0xFF, 0x8A, 0x00, 0xFD, 0xA6 };
        byte[] DSROnByteStream = { 0x07, 0xC6, 0x04, 0x00, 0xFF, 0x8A, 0x04, 0xFD, 0xA2 };
        SSIdll.ssidll ssidll = new SSIdll.ssidll();
        enum currentState { NOTHING, WAITING_VERSION, WAITING_CAP,WAITING_CMD, DONE };
        currentState curr = currentState.NOTHING;

/// <summary>
/// 
/// </summary>
        public exDSRNET()
        {
            InitializeComponent();
            string []ports = SerialPort.GetPortNames();
            foreach (string p in ports)
                this.comboBox1.Items.Add(p);
            
          
        }
       
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
       
            curr = currentState.WAITING_VERSION;
            txtBoxMsgs.Text = "";
           
           
            try
            {
                string port = (string)this.comboBox1.SelectedItem;
                if (port != null)
                {
                 
                    ssidll.scannerMsgs += msgFromScanner;
                    if (ssidll.SSIConnect(9600, port) == 0)
                    {
                       toolStripStatusLabel1.Text = "Attempting connection";
                        ssidll.TransmitVersion();
                    }
                    else
                        toolStripStatusLabel1.Text = "Cannot open RS232 port";
                   
                }
               
             }
             catch (Exception ex)
             {
                 this.statusStrip1.Text = ex.ToString();
             }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="cmd"></param>
        /// <param name="val"></param>
        void inWindowMsg(msgType msg, SSIProtocol.SSI_COMMAND cmd, object val)
        {
            // can update controls in this context
            if (chkBoxMonitorDSR.CheckState == CheckState.Checked)
            {
                Console.WriteLine("Is checked " + msg.ToString());

            }
            switch (msg)
            {
                case msgType.TIMEOUT:
                    {
                        string ss = val as string;
                         this.toolStripStatusLabel1.Text = ss;//SR Comment out so not show Time out on status bar
                        curr = currentState.DONE;
                        ssidll.toggleDTR();
                        txtBoxMsgs.AppendText( "No ACK/NAK, reset state\r\n");
                        //SR txtBoxMsgs.AppendText("Sending Command");
                    }
                    break;
                case msgType.SCANNER_CMD:
                    switch (cmd)
                    {
                        case SSIProtocol.SSI_COMMAND.REPLY_REVISION:
                            {
                                string ss = val as string;
                                txtBoxMsgs.Text = "Got Revision info\r\n";
                                this.toolStripStatusLabel1.Text = "Connected";
                                curr = currentState.WAITING_CAP;

                                string[] ver = ss.Split(' ');
                                txtBoxMsgs.AppendText("Software Revision: " + ver[0] + "\r\n");
                                txtBoxMsgs.AppendText("Board Type: " + ver[1] + "\r\n");

                                Thread.Sleep(100);
                                // we can work on decode next
                                ssidll.RequestScannerCapabilities();

                            }
                            break;

                        case SSIProtocol.SSI_COMMAND.CAPABILITIES_REPLY:
                            {
                                byte [] cap = val as byte[];
                                txtBoxMsgs.AppendText("Recevied CAP info\r\n");
                                this.toolStripStatusLabel1.Text = "Connected";
                                curr = currentState.DONE;
                                int offset =0;
                                ushort baud = (ushort)(cap[offset++] << 8); 
                                baud |= (ushort)cap[offset++];

                                 txtBoxMsgs.AppendText("Baud rates supported ");

                                 for (int i = 0, b = 300; i < 17; i++)
                                 {
                                     if (((1 << i) & baud) != 0)
                                         txtBoxMsgs.AppendText( " " + b.ToString() + " ");
                                     if (b < 28800)
                                         b *= 2;
                                     else
                                     {
                                         switch (i)
                                         {
                                             case 0x0100:
                                                 b = 38400;
                                                 break;
                                             case 0x0200:
                                                 b = 57600;
                                                 break;
                                             case 0x0400:
                                                 b = 115200;
                                                 break;
                                         }
                                     }
                                 }

                                txtBoxMsgs.AppendText( "\r\n");
                            }
                            break;

                        case SSIProtocol.SSI_COMMAND.DECODE_DATA:
                            {
                                byte[] barcode = val as byte[];
                                txtBoxMsgs.AppendText("Received decode\r\n");//SR clear window
                                this.toolStripStatusLabel1.Text = "Connected";
                                curr = currentState.DONE;
                                if (barcode.Length > 1)
                                {
                                    switch (barcode[0])
                                    {
                                        case 1:
                                            txtBoxMsgs.AppendText("Code 39\r\n");
                                            break;
                                        case 2:
                                            txtBoxMsgs.AppendText("Codabar \r\n");
                                            break;
                                        case 3:
                                            txtBoxMsgs.AppendText ("Code 128 \r\n");
                                            break;
                                        case 4:
                                            txtBoxMsgs.AppendText( "Discrete 2 of 5 \r\n");
                                            break;
                                        case 6:
                                            txtBoxMsgs.AppendText("Interleaved 2 of 5\r\n");
                                            break;
                                        case 7:
                                            txtBoxMsgs.AppendText("Code 93 \r\n");
                                            break;

                                        case 8:
                                            txtBoxMsgs.AppendText("Code 128 \r\n");
                                            break;
                                        case 0x9:
                                            txtBoxMsgs.AppendText("UPC A E0\r\n");
                                            break;
                                        case 0x0b:
                                            txtBoxMsgs.AppendText("EAN 13\r\n");
                                            break;
                                        case 0x0e:
                                            txtBoxMsgs.AppendText("MSI\r\n");
                                            break;
                                        case 0x0f:
                                            txtBoxMsgs.AppendText("EAN 128\r\n");
                                            break;
                                        case 0x10:
                                            txtBoxMsgs.AppendText( "UPC E1\r\n");
                                            break;
                                        case 0x48:
                                            txtBoxMsgs.AppendText("UPC A with 2 Supps\r\n");
                                            break;
                                        case 0x49:
                                            txtBoxMsgs.AppendText("UPC E0 with 2\r\n");
                                            break;
                                        case 0x4B:
                                            txtBoxMsgs.AppendText("EAN 13 with 2 Supps\r\n");
                                            break;
                                        case 0x50:
                                            txtBoxMsgs.AppendText("UPC E1 with 5upps\r\n");
                                            break;
                                        case 0x88:
                                            txtBoxMsgs.AppendText("UPC A with 5 Supps\r\n");
                                            break;
                                        case 0x89:
                                            txtBoxMsgs.AppendText("UPC E0 with 5 Supps\r\n");
                                            break;
                                        case 0x8B:
                                            txtBoxMsgs.AppendText("EAN 13 with 5 Supps\r\n");
                                            break;
                                        default:
                                            txtBoxMsgs.AppendText("Unkown format \r\n");
                                            break;
                                    }
                                }
                                if (barcode.Length > 1)
                                {
                                    string upc = Encoding.ASCII.GetString(barcode,1,barcode.Length-1);
                                    txtBoxMsgs.AppendText( upc + "\r\n");
                                    
                                }
                            }
                            break;

                        case SSIProtocol.SSI_COMMAND.CMD_ACK:
                        case SSIProtocol.SSI_COMMAND.CMD_NAK:
                        {
                            string ss = val as string;
                            txtBoxMsgs.AppendText( "ACK received\r\n");
                            this.toolStripStatusLabel1.Text = "Connected";
                            curr = currentState.DONE;
                        }
                        break;

                    }
                    break;
                case msgType.DSR_STATUS:
                {
                    bool dsr = (bool)val;
                    if (dsr)
                    {
                        textBoxDS.Text = "ON";

                        if ((curr == currentState.DONE) && (chkBoxMonitorDSR.CheckState == CheckState.Checked))
                        {
                            txtBoxMsgs.Text = "Auto Detect turning on LED \r\n";
                            ssidll.SetParameters((byte)0x4, (byte)0x8a);
                            Console.WriteLine("Sending LED ON SetParam");
                        }
                       
                     }
                     else
                     {
                         textBoxDS.Text = "OFF";
                         if ((curr == currentState.DONE) && (chkBoxMonitorDSR.CheckState == CheckState.Checked))
                         {
                             txtBoxMsgs.Text = "Auto Detect turning off LED\r\n";
                             ssidll.SetParameters((byte)0x0, (byte)0x8a);
                             Console.WriteLine("Sending LED off SetParam");
                         }
                        //  serialPort.Write(DSROffByteStream, 0, DSROffByteStream.Length);
                       //   string ss = Encoding.ASCII.GetString(DSROffByteStream, 0, DSROffByteStream.Length);
                       //   object[] obj = new object[1];
                      //    obj[0] = (object)DSROffByteStream;
                      //    this.Invoke(new uuS(updateTxData), obj);
                    }
                }
                break;
            }
            

        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="cmd"></param>
        /// <param name="val"></param>
        void msgFromScanner(msgType msg, SSIProtocol.SSI_COMMAND cmd, object val)
        {
            object[] obj = new object[3];
            obj[0] = msg;
            obj[1] = cmd;
            obj[2] = val;
            this.Invoke(new msgFromScanner(inWindowMsg), obj); 
        }
              
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnEnable_Click(object sender, EventArgs e)
        {
            this.toolStripStatusLabel1.Text = "Sending Command";
            ssidll.ScanEnable();
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDisble_Click(object sender, EventArgs e)
        {
            this.toolStripStatusLabel1.Text = "Sending Command";
            ssidll.ScanDisable();
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSetSingleParm_Click(object sender, EventArgs e)
        {
            Int16 offset;
            Int16 val;
            
            try
            {
                offset = Convert.ToInt16(txtBoxParmNum.Text);
            }
            catch(Exception ex)
            {
                MessageBox.Show("ERROR: Parameter Number to large, must between 0 and 127");
                return;
            }

            try
            {
                 val = Convert.ToInt16(txtBoxValue.Text);
            }
            catch (Exception ex)
            {
                MessageBox.Show("ERROR: Parameter Number to large, must between 0 and 127");
                return;
            }
           if (offset >= 0xF0 || offset < 0)
            {
               MessageBox.Show("ERROR: Parameter Number not supported " + offset.ToString());
                return;
            }

            if (val >= 0xFF || offset < 0)
            {
                MessageBox.Show("ERROR","ERROR: Value larger then 127 is not supported");
                return;
            }

            if (curr == currentState.DONE) //TCM FIX
            {
                curr = currentState.WAITING_CMD;
                txtBoxMsgs.AppendText( "Sending Set Parameter\r\n");
                ssidll.SetParameters((byte)val, (byte)offset);
                this.toolStripStatusLabel1.Text = "Sending Command";
            }
            else
            {
                MessageBox.Show( "Not Ready", "ERROR");
            }
         
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnClear_Click(object sender, EventArgs e)
        {
            this.txtBoxMsgs.Clear();
            this.toolStripStatusLabel1.Text = "Ready";
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnClose_Click(object sender, EventArgs e)
        {
            if (ssidll!= null)
            {
                this.ssidll.SSIDisconnect();
                toolStripStatusLabel1.Text = "Disconnected";
                
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void chkBoxMonitorDSR_CheckedChanged(object sender, EventArgs e)
        {
            int rc=0;
           
            if (-1 != (rc=ssidll.getDSR()))
                if (rc == 0)
                {

                    msgFromScanner(msgType.DSR_STATUS, SSIProtocol.SSI_COMMAND.NOTHING, (object)false);
                   
                }
                else
                {

                    msgFromScanner(msgType.DSR_STATUS, SSIProtocol.SSI_COMMAND.NOTHING, (object)true);
                 
                }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBoxDS_TextChanged(object sender, EventArgs e)
        {

        }

       

      

    }
}