/*
	CygUSB721XDemo - Copyright (C) 2007 Cygnetron Inc.


	CygUSB721XDemo is free software; you can redistribute it and/or modify.
	
	CygUSB721XDemo is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 

*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.IO.Ports;
//using System.Timers;


namespace SSIdll
{
    public enum msgType
    {
        TIMEOUT,
        CONNECT,
        DISCONNECT,
        SCANNER_CMD,
        DSR_STATUS
    }
    public delegate void msgFromScanner(msgType msg, SSIProtocol.SSI_COMMAND cmd, object val);

    public interface ISSIdll
    {

        int SSIConnect(long Baud, string Port);
        int SSIDisconnect();
        int TransmitVersion();
       
    }

    public class SSIProtocol
    {
        readonly int SSI_SOURCE_HOST = 0x04;
        readonly int SSI_SOURCE_DECODER= 0x00;
        readonly int SSI_MAX_PACKET_LENGTH= 258;
        readonly int SSI_HEADER_LEN=        4;
        readonly int SSI_CHECKSUM_LEN = 2;

       public enum SSI_COMMAND
        {
            FLUSH_MACRO_PDF = 0x10,
            ABORT_MACRO_PDF = 0x11,
            REQUEST_REVISION= 0xA3,
            REPLY_REVISION= 0xA4,
            IMAGE_DATA = 0xB1,
            VIDEO_DATA = 0xB4,
            AIM_OFF  = 0xC4,
            AIM_ON  =  0xC5,
            PARAM_SEND = 0xC6,
            PARAM_REQUEST = 0xC7,
            PARAM_DEFAULTS	=       0xC8,
            CMD_ACK				      =0xD0,
            CMD_NAK				      =0xD1,
            FLUSH_QUEUE			      =0xD2,
            CAPABILITIES_REQUEST    =0xD3,
            CAPABILITIES_REPLY	   =0xD4,
            BATCH_REQUEST		    =  0xD5,
            BATCH_DATA			     = 0xD6,
            START_SESSION		     = 0xE4,
            STOP_SESSION		     = 0xE5,
            BEEP				     =   0xE6,  
            LED_ON				      =0xE7,
            LED_OFF				      =0xE8,
            SCAN_ENABLE			      =0xE9,
            SCAN_DISABLE		      =0xEA,
            SLEEP				      =   0xEB,
            DECODE_DATA			      =0xF3,
            EVENT				       = 0xF6,
            IMAGER_MODE			      =0xF7,
           NOTHING                  
            
        }
        public enum USER_EVENT
        {
            // events affecting the the state machine from the user
            USER_CMD_EVENT=2,	// user wants to send a simple cmd to the decoder
            USER_BATCHDATAREQ_EVENT=3,	// user wants batch data, param data, revision data, or capabilities data from decoder
            USER_PARAMDATAREQ_EVENT=4,	// user wants batch data, param data, revision data, or capabilities data from decoder
            USER_REVDATAREQ_EVENT=5,	// user wants batch data, param data, revision data, or capabilities data from decoder
            USER_CAPDATAREQ_EVENT=6,	// user wants batch data, param data, revision data, or capabilities data from decoder
            USR_NAK_CANCEL_EVENT=7, 
        }

        public bool ServiceUserCommand(USER_EVENT nEvent, SSI_COMMAND CmdCode, byte[] parm, out byte[] SSIBuffer)
        {
            SSIBuffer = null;

            switch (nEvent)
            {
                case USER_EVENT.USER_CMD_EVENT:

                    UInt16 Checksum;
                    int i;

                    SSIBuffer = new byte[6 + parm.Length];
                    SSIBuffer[0] = 0;
                    SSIBuffer[1] = (byte)CmdCode;
                    SSIBuffer[2] = (byte)SSI_SOURCE_HOST;
                    SSIBuffer[3] = 0; //retries
                    for (i = 0; i < parm.Length; i++)
                        SSIBuffer[4 + i] = parm[i];

                    SSIBuffer[0] = (byte)(SSI_HEADER_LEN + parm.Length);
                    Checksum = 0;

                    for (i = 0; i < (int)SSIBuffer[0]; i++)
                        Checksum += SSIBuffer[i];

                    i = SSI_HEADER_LEN + parm.Length;
                    SSIBuffer[i++] = (byte)(((-Checksum) >> 8) & 0xFF);
                    SSIBuffer[i++] = (byte)((-Checksum) & 0xFF);
                    return true;
                    

            }
            return false;

        }
        public bool ServiceUserCommand(USER_EVENT nEvent, SSI_COMMAND CmdCode, out byte[] SSIBuffer)
        {
            SSIBuffer = null;

            switch (nEvent)
            {
                case USER_EVENT.USER_REVDATAREQ_EVENT:
                case USER_EVENT.USER_CAPDATAREQ_EVENT:
                case USER_EVENT.USER_CMD_EVENT:
          
                    UInt16 Checksum;
                    int i;

                    SSIBuffer = new byte[6];
                    SSIBuffer[0] = 0;
                    SSIBuffer[1] = (byte)CmdCode;
                    SSIBuffer[2] = (byte)SSI_SOURCE_HOST;
                    SSIBuffer[3] = 0; //retries

                    SSIBuffer[0] = (byte)(SSI_HEADER_LEN + 0);
                    Checksum = 0;

                    for ( i = 0; i < (int)SSIBuffer[0]; i++)
                        Checksum += SSIBuffer[i];

                    i = SSI_HEADER_LEN + 0;
                    SSIBuffer[i++] = (byte)(((-Checksum) >> 8) & 0xFF);
                    SSIBuffer[i++] = (byte)((-Checksum) & 0xFF);
                    return true;
             

            }
            return false;
        }
    }
    public class ssidll: ISSIdll
    {

        readonly int TIMEOUTVAL = 1000;  //ms

        System.IO.Ports.SerialPort serialPort;
        SSIProtocol ProtocolHandler;
       
        //MAX buff size
        byte[] currBuff = new byte[256];
        int offset= 0;
        SerialPinChangedEventHandler pinChangeHandler;
        System.Timers.Timer timerForMonitor = new System.Timers.Timer(3000);
        DateTime currTimeDate;
        

        public event msgFromScanner scannerMsgs;


        public ssidll()
        {
            ProtocolHandler = new SSIProtocol();
            this.timerForMonitor.Elapsed += ElapsedEventHandler;
           
            timerForMonitor.Stop();
        }



        void StartTimer()
        {
            currTimeDate = DateTime.Now;
            currTimeDate.AddMilliseconds(TIMEOUTVAL);
            timerForMonitor.Start();
        }

        public int SSIConnect(long Baud, string Port)
        {
            offset = 0;
            if (serialPort != null)
            {
                serialPort.PinChanged -= pinChangeHandler;
                serialPort.DtrEnable = false;
                Thread.Sleep(100);
                serialPort.Close();
                serialPort = null;
            }
            try
            {
                serialPort = new System.IO.Ports.SerialPort();
                serialPort.RtsEnable = true;            
                serialPort.Handshake = System.IO.Ports.Handshake.None;
                serialPort.PortName = Port;
                 serialPort.Open();
                 pinChangeHandler = new SerialPinChangedEventHandler(this.pinChanges); 
                serialPort.DataReceived += new SerialDataReceivedEventHandler(rcvRs232Data);
                serialPort.PinChanged += pinChangeHandler;
                serialPort.RtsEnable = true;
                serialPort.DtrEnable = false;
                Thread.Sleep(300);
                serialPort.RtsEnable = false;
                serialPort.DtrEnable = true;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                return -1;
            }
            return 0;
        }

      
        public int SSIDisconnect( )
        {
            if (serialPort != null)
            {
                serialPort.PinChanged -= pinChangeHandler;
                serialPort.RtsEnable = false;//Changed to RTS
                serialPort.Close();
                serialPort = null;
            }
            return 0;
        }
        private void pinChanges(object sender, SerialPinChangedEventArgs e)
        {
            SerialPinChange ev = e.EventType;
            if ((ev & SerialPinChange.DsrChanged) == SerialPinChange.DsrChanged && serialPort != null)
               scannerMsgs(msgType.DSR_STATUS,SSIProtocol.SSI_COMMAND.NOTHING, serialPort.DsrHolding);   

        }

        private void ElapsedEventHandler(object sender, System.Timers.ElapsedEventArgs e)
        {
            timerForMonitor.Stop();
                scannerMsgs(msgType.TIMEOUT, SSIProtocol.SSI_COMMAND.NOTHING, "Time out");
           
        }

        private void rcvRs232Data(object sender, SerialDataReceivedEventArgs e)
        {
            this.timerForMonitor.Stop();

           if (serialPort != null)
            {
                int numOfChars = serialPort.BytesToRead;

                serialPort.Read(currBuff, offset, numOfChars);
                offset += numOfChars;

                Console.WriteLine("data " + numOfChars);

                if (offset > 2 && (currBuff[0] == offset-2))
                {
                    SSIProtocol.SSI_COMMAND cmd = (SSIProtocol.SSI_COMMAND)currBuff[1];
                    switch (cmd)
                    {
                        case SSIProtocol.SSI_COMMAND.REPLY_REVISION:
                        {
                                string UIString = Encoding.ASCII.GetString(currBuff, 4, offset - 4);

                                scannerMsgs(msgType.SCANNER_CMD, SSIProtocol.SSI_COMMAND.REPLY_REVISION, UIString);
                                offset = 0;
                        }
                        break;

                        case SSIProtocol.SSI_COMMAND.CAPABILITIES_REPLY:
                        {
                                byte[] cap = new byte[offset - 6];
                                Array.Copy(currBuff, 4, cap, 0, offset - 6);

                                scannerMsgs(msgType.SCANNER_CMD,SSIProtocol.SSI_COMMAND.CAPABILITIES_REPLY,cap);                                     
                                offset = 0;
                        }
                        break;
                        case SSIProtocol.SSI_COMMAND.DECODE_DATA:
                        {
                            byte[] cap = new byte[offset - 6];
                            Array.Copy(currBuff, 4, cap, 0, offset - 6);
                            scannerMsgs(msgType.SCANNER_CMD, SSIProtocol.SSI_COMMAND.DECODE_DATA, cap);
                            offset = 0;
                            PacketAck();

                        }
                    break;
                        case SSIProtocol.SSI_COMMAND.CMD_ACK:
                        case SSIProtocol.SSI_COMMAND.CMD_NAK:
                            {
                                string UIString = "";
                                Console.WriteLine("RX ACK or NAK");
                                scannerMsgs(msgType.SCANNER_CMD, SSIProtocol.SSI_COMMAND.CMD_ACK, UIString);
                                offset = 0;
                            }
                            break;
                        
                        default:
                                Console.WriteLine("Hey");
                                offset = 0;
                                break;
                        }
                    }
               }
        }
        public int TransmitVersion()
        {
            byte[] SSIBuffer;
            if (ProtocolHandler.ServiceUserCommand(SSIProtocol.USER_EVENT.USER_REVDATAREQ_EVENT,
                                                SSIProtocol.SSI_COMMAND.REQUEST_REVISION, out SSIBuffer))
            {
                serialPort.RtsEnable = true;
                serialPort.Write(SSIBuffer, 0, SSIBuffer.Length);
                while (serialPort.BytesToWrite != 0)
                    Thread.Sleep(1);
                serialPort.RtsEnable = false;
               
               
                Console.WriteLine("Version Started Timer");
               
            }
            return 0;
        }

        public int RequestScannerCapabilities()
        {
            byte[] SSIBuffer;
         
            if (ProtocolHandler.ServiceUserCommand(SSIProtocol.USER_EVENT.USER_CAPDATAREQ_EVENT,
                                                SSIProtocol.SSI_COMMAND.CAPABILITIES_REQUEST, out SSIBuffer))
            {
                serialPort.RtsEnable = true;
                serialPort.Write(SSIBuffer, 0, SSIBuffer.Length);
                while (serialPort.BytesToWrite != 0)
                    Thread.Sleep(1);

                serialPort.RtsEnable = false;

                Console.WriteLine("Cap Started Timer");
            }
            return 0;
        }

        public int ScanEnable()
        {
            byte[] SSIBuffer;
            if (ProtocolHandler.ServiceUserCommand(SSIProtocol.USER_EVENT.USER_CMD_EVENT,
                                                SSIProtocol.SSI_COMMAND.SCAN_ENABLE, out SSIBuffer))
            {
                serialPort.RtsEnable = true;
                serialPort.Write(SSIBuffer, 0, SSIBuffer.Length);
                while (serialPort.BytesToWrite != 0)
                    Thread.Sleep(1);

                serialPort.RtsEnable = false;

                Console.WriteLine("Scan Enable Started Timer");
            }
            return 0;
        }


        public int ScanDisable()
        {
            byte[] SSIBuffer;
            if (ProtocolHandler.ServiceUserCommand(SSIProtocol.USER_EVENT.USER_CMD_EVENT,
                                                SSIProtocol.SSI_COMMAND.SCAN_DISABLE, out SSIBuffer))
            {
                serialPort.RtsEnable = true;
                serialPort.Write(SSIBuffer, 0, SSIBuffer.Length);
                while (serialPort.BytesToWrite != 0)
                    Thread.Sleep(1);

                serialPort.RtsEnable = false;

                Console.WriteLine("Scan disable Started Timer");
            }
            return 0;
        }


        public int PacketAck()
        {
            byte[] SSIBuffer;
            if (ProtocolHandler.ServiceUserCommand(SSIProtocol.USER_EVENT.USER_CMD_EVENT,
                                                SSIProtocol.SSI_COMMAND.CMD_ACK, out SSIBuffer))
            {
                serialPort.RtsEnable = true;
                serialPort.Write(SSIBuffer, 0, SSIBuffer.Length);
                while (serialPort.BytesToWrite != 0)
                    Thread.Sleep(1);

                serialPort.RtsEnable = false;

                Console.WriteLine("Started Timer");
            }
            return 0;
        }

 
      
        public int SetParameters(byte cmdData, byte cmd)
        {
            byte[] SSIBuffer;
            int offset =0;
            byte[] pkt = new byte[3];

            pkt[offset++]= 0xff;
            pkt[offset++] = cmd;
            pkt[offset++] = cmdData;
            
            if (ProtocolHandler.ServiceUserCommand(SSIProtocol.USER_EVENT.USER_CMD_EVENT,
                                                SSIProtocol.SSI_COMMAND.PARAM_SEND,pkt, out SSIBuffer))
            {
                this.timerForMonitor.Start();
                serialPort.RtsEnable = true;
                serialPort.Write(SSIBuffer, 0, SSIBuffer.Length);
                while (serialPort.BytesToWrite != 0)
                    Thread.Sleep(10);

                serialPort.RtsEnable = false;
                //Thread.Sleep(100);
                //serialPort.RtsEnable = true;
                //Thread.Sleep(100);
                //serialPort.RtsEnable = false;
                
                Console.WriteLine("Set Params Started Timer");
                
            }
            return 0;
        }

        public int RequestParameters(byte[] cmdData)
        {
            byte[] SSIBuffer;
            if (ProtocolHandler.ServiceUserCommand(SSIProtocol.USER_EVENT.USER_CMD_EVENT,
                                                SSIProtocol.SSI_COMMAND.PARAM_REQUEST, cmdData, out SSIBuffer))
            {
                serialPort.RtsEnable = true;
                serialPort.Write(SSIBuffer, 0, SSIBuffer.Length);
                while (serialPort.BytesToWrite != 0)
                    Thread.Sleep(1);

                serialPort.RtsEnable = false;

                Console.WriteLine("Request Params Started Timer");
            }
            return 0;
        }

        public int getDSR()
        {
            if (serialPort == null)
                return -1;

            if (!serialPort.IsOpen)
                return -1;

            if (serialPort.DsrHolding)
                return 1;
            return 0;
                
        }

        public void toggleDTR()
        {
            if (serialPort == null)
                return;
            if (serialPort.IsOpen)
            {//SR changing to RtsEnable solves LED turn ON
                serialPort.DtrEnable = false;
                Thread.Sleep(100); 
                serialPort.DtrEnable = true;
            }
        }
    }
}
