/////////////////////////////////////////////////////////////////////
//
// OposMsr.h
//
//   Magnetic Stripe Reader header file for OPOS Applications.
//
// Modification history
// ------------------------------------------------------------------
// 1995-12-08 OPOS Release 1.0                                   CRM
// 1997-06-04 OPOS Release 1.2                                   CRM
//   Add ErrorReportingType constants.
// 2000-09-24 OPOS Release 1.5                                   BKS
//   Add constants relating to Track 4 Data.
//   (01-07-15 Added omitted MSR_TR_1_3_4 property)
// 2006-03-15 OPOS Release 1.10                                  CRM
//   Add the following properties:
//     CapWritableTracks, EncodingMaxLength, TracksToWrite
//
/////////////////////////////////////////////////////////////////////

#if !defined(OPOSMSR_H)
#define      OPOSMSR_H


#include "Opos.h"


/////////////////////////////////////////////////////////////////////
// "TracksToRead", "CapWritableTracks", "TracksToWrite" Property Constants
/////////////////////////////////////////////////////////////////////

const LONG MSR_TR_NONE          = 0;	// (added in 1.10)
										// "CapWritableTracks", "TracksToWrite"

const LONG MSR_TR_1             = 1;
const LONG MSR_TR_2             = 2;
const LONG MSR_TR_3             = 4;
const LONG MSR_TR_4             = 8;    // (added in 1.5)

const LONG MSR_TR_1_2           = 0x03;
const LONG MSR_TR_1_3           = 0x05;
const LONG MSR_TR_1_4           = 0x09; // (added in 1.5)
const LONG MSR_TR_2_3           = 0x06;
const LONG MSR_TR_2_4           = 0x0A; // (added in 1.5)
const LONG MSR_TR_3_4           = 0x0C; // (added in 1.5)

const LONG MSR_TR_1_2_3         = 0x07;
const LONG MSR_TR_1_2_4         = 0x0B; // (added in 1.5)
const LONG MSR_TR_1_3_4         = 0x0D; // (added in 1.5)
const LONG MSR_TR_2_3_4         = 0x0E; // (added in 1.5)

const LONG MSR_TR_1_2_3_4       = 0x0F; // (added in 1.5)


/////////////////////////////////////////////////////////////////////
// "ErrorReportingType" Property Constants (added in 1.2)
/////////////////////////////////////////////////////////////////////

const LONG MSR_ERT_CARD         = 0;
const LONG MSR_ERT_TRACK        = 1;


/////////////////////////////////////////////////////////////////////
// "ErrorEvent" Event: "ResultCodeExtended" Parameter Constants
/////////////////////////////////////////////////////////////////////

const LONG OPOS_EMSR_START      = 201;
const LONG OPOS_EMSR_END        = 202;
const LONG OPOS_EMSR_PARITY     = 203;
const LONG OPOS_EMSR_LRC        = 204;


#endif                  // !defined(OPOSMSR_H)
