REM SPT Session commands
REM =====================

REM SMBUS slave address = 0x04.
REM SMBUS command = 0xE0.
REM UserID = 0x00.
REM Tag number(all commands) = 0x01.


REM Command = 0x21. (Set Offload parameter 1)
REM MC Session ID = 0x00 0x01 0x02 0x03.
REM MS System Session ID = 0x04 0x05 0x06 0x07.
REM MC Auth. Seq. Number = 0x08 0x09 0x0A 0x0B.
REM MC Unauth. Seq. Number = 0x0C 0x0D 0x0E 0x0F.
REM MC Auth. Seq. Bit-Map = 0x10 0x11.
REM MC Unauth. Seq. Bit-Map = 0x12 0x13.
REM MS Auth. Seq. Number = 0x14 0x15 0x16 0x17.
REM MS Unauth. Seq. Number = 0x18 0x19 0x1A 0x1B.
REM -----------------------------------------------------------------

blwrite 0x04 0xE0 0x1E 0x01 0x21 0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09 0x0A 0x0B 0x0C 0x0D 0x0E 0x0F 0x10 0x11 0x12 0x13 0x14 0x15 0x16 0x17 0x18 0x19 0x1A 0x1B
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0x22. (Set Offload parameter 2)
REM Session ID = 0x00 0x01 0x02 0x03.
REM Session Integrity key = 0102030405060708090A0B0C0D0E0F1011121314.
REM -----------------------------------------------------------------

blwrite 0x04 0xE0 0x1A 0x01 0x22 0x00 0x01 0x02 0x03 0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09 0x0A 0x0B 0x0C 0x0D 0x0E 0x0F 0x10 0x11 0x12 0x13 0x14
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00


REM Command = 0x23. (Set Offload parameter 3)
REM Session ID = 0x00 0x01 0x02 0x03.
REM Auxiliary Request Data = 0x04 0x05 0x06 0x07.
REM Payload Instance = 0x08.
REM User ID = 0x00.
REM Max. Privilege Level = 0x02. (User)
REM Integrity algorithm = 0x01. (HMAC SHA1 96)
REM Confidentiality algorithm = 0x01. (AES-CBC-128)
REM Payload Type = 0x01 (SOL).
REM Console MAC address = 0x01 0x02 0x03 0x04 0x05 0x06.
REM Console IP address = 0x01 0x02 0x03 0x04.
REM Console UDP port = 0x05 0x06.
REM VLAN Tag = 0x00 0x00. (Not present)
REM -----------------------------------------------------------------

blwrite 0x04 0xE0 0x1E 0x01 0x23 0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x00 0x02 0x01 0x01 0x01 0x01 0x02 0x03 0x04 0x05 0x06 0x01 0x02 0x03 0x04 0x05 0x06 0x00 0x00
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0xF0 0x00

blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0x2F 0x00 0x01 0x02 0x03



REM Command = 0x20. (Close session command)
REM Session ID = 0x00 0x01 0x02 0x03.
REM -----------------------------------------------------------------

blwrite 0x04 0xE0 0x06 0x01 0x20 0x00 0x01 0x02 0x03
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0x2E 0x00 0x01 0x02 0x03


REM Command = 0x31. (Get Payload Activation Status)
REM Payload type number = 0x01 (SOL)
REM OEM IANA = 0x00 0x00 0x00
REM OEM Payload ID = 0x00 0x00
REM -----------------------------------------------------------------

blwrite 0x04 0xE0 0x08 0x01 0x31 0x01 0x00 0x00 0x00 0x00 0x00
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0x32 X Y Z
REM X=Payload type number. Y=Instance 1-8 status. Z=Instance 9-16 status


REM Command = 0x33. (Get Payload Instance Info)
REM Payload Type Number = 0x01 (SOL)
REM OEM IANA = 0x00 0x00 0x00
REM OEM Payload ID = 0x00 0x00
REM Payload Instance = 0x01
REM -----------------------------------------------------------------

blwrite 0x04 0xE0 0x09 0x01 0x33 0x01 0x00 0x00 0x00 0x00 0x00 0x01
blread  0x04 0xC0

REM Verify that last command returned: 0xE0 0x01 0x34 ID0 ID1 ID2 ID3 X 0x00 0x00 0x00 0x00 0x00 0x00 0x00
REM ID0..ID3=Session ID. X=Port number.
